<?php
namespace CoinGate;

class OrderTest extends TestCase
{
    public function testFindOrderNotFound()
    {
        $this->assertFalse(Terminal\Order::find(0, array(), self::getGoodAuthentication()));

        try {
            $this->assertFalse(Terminal\Order::findOrFail(0, array(), self::getGoodAuthentication()));
        } catch (\Exception $e) {
            $this->assertRegExp('/OrderNotFound/', $e->getMessage());
        }
    }

    public function testFindOrderFound()
    {
        $order = Terminal\Order::create(self::getGoodPostParams(), array(), self::getGoodAuthentication());
        $this->assertNotFalse(Terminal\Order::find($order->id, array(), self::getGoodAuthentication()));
    }

    public function testCreateOrderIsNotValid()
    {
        $this->assertFalse(Terminal\Order::create(array(), array(), self::getGoodAuthentication()));
        try {
            $this->assertFalse(Terminal\Order::createOrFail(array(), array(), self::getGoodAuthentication()));
        } catch (\Exception $e) {
            $this->assertRegExp('/OrderIsNotValid/', $e->getMessage());
        }
    }

    public function testCreateOrderValid()
    {
        $this->assertNotFalse(Terminal\Order::create(self::getGoodPostParams(), array(), self::getGoodAuthentication()));
    }

    public static function getGoodPostParams() {
        return array(
            'order_id'          => 'YOUR-CUSTOM-ORDER-ID-115',
            'price_amount'      => 1000.99,
            'price_currency'    => 'USD',
            'receive_currency'  => 'EUR',
            'callback_url'      => 'https://example.com/payments/callback?token=6tCENGUYI62ojkuzDPX7Jg',
            'cancel_url'        => 'https://example.com/cart',
            'success_url'       => 'https://example.com/account/orders',
            'title'             => 'Order #112',
            'description'       => 'Apple Iphone 6'
        );
    }
}